'use strict';

function RepayLoanCtrl($scope, BanksList){
    var elementId = "#modal-chattel-repay-loan";

    $scope.cbso = false;
    $scope.title = '';
    $scope.repay = 0

    $scope.CurrentAccount = BanksList.getCurrentAccount();

    $scope.maxValue = 0;

    $scope.$on('Chattel:repayLoan', function(event, cbso){
        $scope.cbso = cbso;
        $scope.repay = cbso.value;
        $scope.title = BanksList.getOptionFullName(cbso.option_id);
        $scope.maxValue = ($scope.CurrentAccount.company_bank_service_options[0].value < cbso.value) ? $scope.CurrentAccount.company_bank_service_options[0].value : angular.copy(cbso.value);

        $scope.openModal();
    });

    $scope.openModal = function(){
        angular.element(elementId).modal({
            backdrop: 'static'
            ,keyboard: false
            ,show: true
        });
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

    $scope.repayLoan = function(){
        $scope.cbso.value -= parseFloat($scope.repay);
        $scope.CurrentAccount.company_bank_service_options[0].value -= parseFloat($scope.repay);
        $scope.closeModal();
    }

    $scope.remainingDebt = function(debt, repay){
        return (debt - parseFloat(repay));
    }

    $scope.isValidRepay = function(){
        return (typeof $scope.repay == 'undefined' || isNaN($scope.repay) || $scope.repay <= 0) ? false : true;
    }

}

RepayLoanCtrl.$inject = ['$scope', 'BanksList'];
